//=============================================================================
// Box for ammos.
//=============================================================================
class AmmoChest extends DeusExDecoration;

var bool bOpen;
var Ammo Items[4];
var vector ItemOffsets[4];
var rotator ItemRotations[4];
var float OpenTime;

#exec MESH IMPORT MESH=AmmoBox ANIVFILE=MODELS\AmmoBox_a.3d DATAFILE=MODELS\AmmoBox_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AmmoBox X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=AmmoBox SEQ=All              STARTFRAME=0 NUMFRAMES=6
#exec MESH SEQUENCE MESH=AmmoBox SEQ=AmmoBox STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AmmoBox SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AmmoBox SEQ=Open STARTFRAME=0 NUMFRAMES=6 RATE=8

#exec MESHMAP NEW   MESHMAP=AmmoBox MESH=AmmoBox
#exec MESHMAP SCALE MESHMAP=AmmoBox X=0.042970125 Y=0.042970125 Z=0.042970125

#exec TEXTURE IMPORT FILE="Textures\WeaponBoxGreenLight.pcx"	NAME="AmmoBoxGreenLight"				GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\WeaponBoxRedLight.pcx"	NAME="AmmoBoxRedLight"				GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\WeaponBoxDGrayAlloy.pcx"	NAME="AmmoBoxDGrayAlloy"				GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\WeaponBoxSilverAlloy.pcx"	NAME="AmmoBoxSilverAlloy"				GROUP="Icons" MIPS=Off


#exec MESHMAP SETTEXTURE MESHMAP=AmmoBox NUM=0 TEXTURE=AmmoBoxSilverAlloy
#exec MESHMAP SETTEXTURE MESHMAP=AmmoBox NUM=1 TEXTURE=AmmoBoxDGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=AmmoBox NUM=2 TEXTURE=AmmoBoxGreenLight

#exec OBJ LOAD FILE=MoverSFX

function Frob(Actor Frobber, Inventory FrobWith)
{
 if (bOpen) return;
 
 bOpen = True;
 Multiskins[2] = Texture'AmmoBoxRedLight';
 
 PlaySound(Sound'Pneumatic1Open');
 PlayAnim('Open');
 SetTimer(OpenTime, False);
}

function class<Ammo> RandomAmmoType()
{
 local int r;
 
 r = rand(7);
 
 if (r == 0) return class'AmmoCombatRifle';
 if (r == 1) return class'AmmoLauncher';
 if (r == 2) return class'AmmoPistol';
 if (r == 3) return class'AmmoRevolver';
 if (r == 4) return class'AmmoShotgun';
 if (r == 5) return class'AmmoSMG';
 if (r == 6) return class'AmmoSniper';
}

function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 Items[0] = Spawn(randomammotype());
 Items[1] = Spawn(randomammotype());
 Items[2] = Spawn(randomammotype());
 Items[3] = Spawn(randomammotype());
 
 Items[0].SetPhysics(PHYS_None);
 Items[1].SetPhysics(PHYS_None);
 Items[2].SetPhysics(PHYS_None);
 Items[3].SetPhysics(PHYS_None);
 
 Items[0].SetCollisionSize(0,0);
 Items[1].SetCollisionSize(0,0);
 Items[2].SetCollisionSize(0,0);
 Items[3].SetCollisionSize(0,0);

}

function Tick(float DT)
{
 Super.Tick(DT);
 
 if (Items[0] != None)
 {
  Items[0].SetLocation(Location + (ItemOffsets[0] >> Rotation));
  Items[0].SetRotation(Rotation + ItemRotations[0]);
 }
 if (Items[1] != None)
 {
  Items[1].SetLocation(Location + (ItemOffsets[1] >> Rotation));
  Items[1].SetRotation(Rotation + ItemRotations[1]);
 }
 if (Items[2] != None)
 {
  Items[2].SetLocation(Location + (ItemOffsets[2] >> Rotation));
  Items[2].SetRotation(Rotation + ItemRotations[2]);
 }
 if (Items[3] != None)
 {
  Items[3].SetLocation(Location + (ItemOffsets[3] >> Rotation));
  Items[3].SetRotation(Rotation + ItemRotations[3]);
 }
}

function Timer()
{
 Items[0].SetCollisionSize(Items[0].Default.CollisionRadius, Items[0].Default.CollisionHeight);
 Items[1].SetCollisionSize(Items[1].Default.CollisionRadius, Items[1].Default.CollisionHeight);
 Items[2].SetCollisionSize(Items[2].Default.CollisionRadius, Items[2].Default.CollisionHeight);
 Items[3].SetCollisionSize(Items[3].Default.CollisionRadius, Items[3].Default.CollisionHeight);
}

defaultproperties
{
     bInvincible=True
     bFlammable=False
     Flammability=0.000000
     MinDamageThreshold=65536
     bPushable=False
     ItemName="Ammo Chest"
     Mesh=LodMesh'AmmoBox'
     CollisionRadius=32.500000
     CollisionHeight=11.000000
     Mass=0.000000
     Buoyancy=0.000000
     //Physics=PHYS_None
     bBlockPlayers=True
     bBlockActors=True
     bCollideActors=True
     bProjTarget=True
     bHighlight=True
     bCanBeBase=True
     Drawscale=2.000000

     ItemOffsets(0)=(X=-8.000000,Y=-8.000000,Z=5.200000)
     ItemOffsets(1)=(X=8.000000,Y=-8.000000,Z=5.200000)
     ItemOffsets(2)=(X=8.000000,Y=8.000000,Z=5.200000)
     ItemOffsets(3)=(X=-8.000000,Y=8.000000,Z=5.200000)
     OpenTime=1.50
}
